﻿using System.Reflection;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.vbecs.Common.Log;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
    /// <summary>
    /// Create VistaLink messaged from byte[]
    /// </summary>
    public class VistaLinkMessageFactory : IMessageFactory
    {
        private readonly VistALinkMessageXmlFactory _messageFactory = new VistALinkMessageXmlFactory( new RpcParameterXmlFactory() );
        // Logger
        private readonly ILogger _logger =
            LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// Creates message object from bytes
        /// </summary>
        /// <param name="bytes">message's array of bytes</param>
        /// <returns></returns>
        public IMessage CreateMessage(byte[] bytes)
        {
            var incomingMessage = _messageFactory.ParseXmlCreateVistALinkMessage(GlobalConfig.NetworkMessageEncoding.GetString(bytes));
            // TODO: pull exception text from resources
            if (incomingMessage == null)
            {
                // Log error
                _logger.Error(string.Format("Unknown message was received from remote party. It cannot be identified as a VistALink message [{0}]", 
                    GlobalConfig.NetworkMessageEncoding.GetString(bytes)));
                throw (new VistALinkException(
                    "Unknown message was received from remote party. It cannot be identified as a VistALink message."));
            }

            return incomingMessage;
        }
    }
}
